/* - AdvServoAttachListener - 
 * populate the available fields and controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.AdvancedServoPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JSlider;

public class AdvServoAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numServosTxt;
    private JComboBox servoCmb;
    private JTextField actVelTxt;
    private JTextField actPosTxt;
    private JTextField currentTxt;
    private JSlider posScrl;
    private JTextField targetPosTxt;
    private JSlider velScrl;
    private JTextField targetVelTxt;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JCheckBox engagedChk;
    private JCheckBox rampingChk;
    
    /** Creates a new instance of AdvServoAttachListener */
    public AdvServoAttachListener(JFrame appFrame, JTextField attachedTxt,
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
            JTextField numServosTxt, JComboBox servoCmb, JTextField actVelTxt,
            JTextField actPosTxt, JTextField currentTxt, JSlider posScrl,
            JTextField targetPosTxt, JSlider velScrl, JTextField targetVelTxt,
            JSlider accelScrl, JTextField accelTxt, JCheckBox engagedChk,
            JCheckBox rampingChk)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numServosTxt = numServosTxt;
        this.servoCmb = servoCmb;
        this.actVelTxt = actVelTxt;
        this.actPosTxt = actPosTxt;
        this.currentTxt = currentTxt;
        this.posScrl = posScrl;
        this.targetPosTxt = targetPosTxt;
        this.velScrl = velScrl;
        this.targetVelTxt = targetVelTxt;
        this.accelScrl = accelScrl;
        this.accelTxt = accelTxt;
        this.engagedChk = engagedChk;
        this.rampingChk = rampingChk;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            AdvancedServoPhidget attached = (AdvancedServoPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numServosTxt.setText(Integer.toString(attached.getMotorCount()));
            
            //the maximum bound of the phidget advancedservo position is 232, it's minimum bound is -22
            posScrl.setMaximum((int)attached.getPositionMax(0));
            posScrl.setMinimum((int)attached.getPositionMin(0));

            //min 0 max 1500
            velScrl.setMaximum((int)attached.getVelocityMax(0));
            velScrl.setMinimum((int)attached.getVelocityMin(0));

            //min 0 max 4590
            accelScrl.setMaximum((int)attached.getAccelerationMax(0));
            accelScrl.setMinimum((int)attached.getAccelerationMin(0));
            
            for(int i = 0; i < attached.getMotorCount(); i++)
            {
                servoCmb.addItem(new Integer(i));
                attached.setPosition(i, 0.0);
                attached.setMaxVelocity(i, 0.0);
                attached.setAcceleration(i, 0.0);
                attached.setMotorOn(i, true);
            }
            
            servoCmb.setSelectedIndex(0);
            servoCmb.setEnabled(true);
            
            engagedChk.setSelected(attached.getMotorOn(0));
            engagedChk.setEnabled(true);
            rampingChk.setSelected(attached.getSpeedRampingOn(0));
            rampingChk.setEnabled(true);
            
            //Use a try-catch block around code where you are getting and displaying the servo position data
            //if the current position state has yet to be set, it will throw a PhidgetException for value not set
            //you can use this to test this and to display that the value is unknown
            try
            {
                actPosTxt.setText(Double.toString(attached.getPosition(0)));
                actVelTxt.setText(Double.toString(attached.getMaxVelocity(0)));
            }
            catch(PhidgetException ex2)
            {
                actPosTxt.setText("Unknown");
                actVelTxt.setText("Unknown");
            }
            
            posScrl.setValueIsAdjusting(true);
            posScrl.setValue(0);
            targetPosTxt.setText(Integer.toString(posScrl.getValue()));
            posScrl.setValueIsAdjusting(false);
            velScrl.setValueIsAdjusting(true);
            velScrl.setValue(0);
            targetVelTxt.setText(Integer.toString(velScrl.getValue()));
            velScrl.setValueIsAdjusting(false);
            accelScrl.setValueIsAdjusting(true);
            accelScrl.setValue(0);
            accelTxt.setText(Integer.toString(accelScrl.getValue()));
            accelScrl.setValueIsAdjusting(false);
            
            posScrl.setEnabled(true);
            velScrl.setEnabled(true);
            accelScrl.setEnabled(true);
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
